<?php
/*
 * login_with_etsy.php
 *
 * @(#) $Id: login_with_etsy.php,v 1.1 2014/03/17 09:45:08 mlemos Exp $
 *
 */

/*
 *  Get the http.php file from http://www.phpclasses.org/httpclient
 */
require('http.php');
require('oauth_client.php');

$client = new oauth_client_class();
$client->debug = false;
$client->debug_http = true;
$client->server = 'Etsy';
$client->redirect_uri = 'http://'.$_SERVER['HTTP_HOST'].
    dirname(strtok($_SERVER['REQUEST_URI'], '?')).'/login_with_etsy.php';

$client->client_id = '';
$application_line = __LINE__;
$client->client_secret = '';
$client->scope = 'email_r';

if (strlen($client->client_id) == 0
|| strlen($client->client_secret) == 0) {
    die('Please go to Etsy Developers page https://www.etsy.com/developers/register , '.
        'create an application, and in the line '.$application_line.
        ' set the client_id to key string and client_secret with shared secret. '.
        'The Callback URL must be '.$client->redirect_uri);
}

if (($success = $client->Initialize())) {
    if (($success = $client->Process())) {
        if (strlen($client->access_token)) {
            $success = $client->CallAPI(
                'https://openapi.etsy.com/v2/users/__SELF__',
                'GET',
                array(),
                array('FailOnAccessError'=>true),
                $user
            );
        }
    }
    $success = $client->Finalize($success);
}
if ($client->exit) {
    exit;
}
if ($success) {
    ?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<title>Etsy OAuth client results</title>
</head>
<body>
<?php
            echo '<h1>', HtmlSpecialChars($user->results[0]->login_name),
    ' you have logged in successfully with Etsy!</h1>';
    echo '<pre>', HtmlSpecialChars(print_r($user, 1)), '</pre>';
    ?>
</body>
</html>
<?php
} else {
    ?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<title>OAuth client error</title>
</head>
<body>
<h1>OAuth client error</h1>
<pre>Error: <?php echo HtmlSpecialChars($client->error); ?></pre>
</body>
</html>
<?php
}

?>